#include <TObject.h>

class CalorimeterCalibration : public TObject {
 public:
    CalorimeterCalibration();
    Int_t  status;
    TString fname;
    Float_t mip[2][22][96]; 
    Float_t ermip[2][22][96];      
    Float_t fp[4][2][22][96]; 
    Float_t fpe[4][2][22][96]; 
    Float_t chi2[2][22][96];      
    Float_t ndf[2][22][96];      
    Float_t mask[2][22][96];
};

class CalorimeterCalibScan : public TObject {
 public:
    CalorimeterCalibScan();
    Int_t evno;
    Int_t etime[4];
    Int_t cstwerr[4];
    Float_t cperror[4];
    Float_t calped[2][22][96];
    Float_t calgood[2][22][96];
    Float_t calthr[2][22][6];
    Float_t calrms[2][22][96];
    Float_t calbase[2][22][6];
    Float_t calvar[2][22][6];
    Double_t calno;
};

CalorimeterCalibScan::CalorimeterCalibScan() {    
    calno = 0.;
    evno = 0;
    for (Int_t a = 0; a < 4 ; a++){
	etime[a] = 0;
	cperror[a] = 0.;
	cstwerr[a] = 0;
    };
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		calped[i][j][m] = 0.;
		calgood[i][j][m] = 0.;
		calrms[i][j][m] = 0.;		
		if ( m < 6){
		    calbase[i][j][m] = 0.;
		    calthr[i][j][m] = 0.;
		    calvar[i][j][m] = 0.;
		};
	    };
	};	
    };        
};

class CalorimeterLevel1 : public TObject {
 public:
    CalorimeterLevel1();
    Int_t   evno;    
    Int_t   stwerr[4];    
    Int_t   nobase;
    Int_t   good[2][22][96];
    Float_t perror[4];
    Float_t nstrip;   
    Float_t qtot;
    Float_t calevnum[4];
    Float_t estrip[2][22][96];
    Float_t diffbas[2][22][6];
};

CalorimeterLevel1::CalorimeterLevel1() {    
    evno = 0;
    nobase = 0;
    nstrip = 0.;
    qtot = 0.;
    for (Int_t i=0; i<2;i++){
	stwerr[i] = 0;
	perror[i] = 0.;
	calevnum[i] = 0.;
    };
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		if ( m < 6 ) diffbas[i][j][m] = 0.;
		estrip[i][j][m] = 0.;
		good[i][j][m] = 0;
	    };
	};	
    };        
}


CalorimeterCalibration::CalorimeterCalibration() {    
  fname = "dw_000000_000.dat";
  status = 0;
  for (Int_t i=0; i<2;i++){
    for (Int_t j=0; j<22;j++){
      for (Int_t m=0; m<96;m++){
	mip[i][j][m] = 0.;
	ermip[i][j][m] = 0.;
	chi2[i][j][m] = 0.;
	ndf[i][j][m] = 0.;
	mask[i][j][m] = 0.;
	for (Int_t a = 0; a < 4 ; a++){
	  fp[a][i][j][m] = 0.;
	  fpe[a][i][j][m] = 0.;
	};
      };
    };	
  };        
};

class CalorimeterLevel2 : public TObject {
 public:
    CalorimeterLevel2();
    Int_t OBT;
    Int_t pkt_num;
    Int_t pro_num;
    Float_t trigty;
    Bool_t good;
    Bool_t perr[4];
    Bool_t swerr[4];
    Bool_t crc[4];
    Float_t nstrip;
    Float_t qtot;
    Float_t ncore;
    Float_t qcore;
    Float_t impx;
    Float_t impy;
    Float_t tanx;
    Float_t tany;
    Float_t nint;
    Float_t ncyl;
    Float_t qcyl;
    Float_t qtrack;
    Float_t qmax;
    Float_t nx22;
    Float_t qx22;
    Float_t qq[4];
    Float_t qtrackx;
    Float_t qtracky;
    Float_t dxtrack;
    Float_t dytrack;
    Float_t qlast;
    Float_t nlast;
    Float_t qpre;
    Float_t npre;
    Float_t qpresh;
    Float_t npresh;
    Float_t qlow;
    Float_t nlow;
    Float_t qtr;
    Float_t ntr;
    Int_t cibar[22][2];
    Int_t tibar[22][2];
    Float_t cbar[22][2];
    Float_t tbar[22][2];
};
CalorimeterLevel2::CalorimeterLevel2() {    
    OBT = 0;
    pkt_num = 0;
    pro_num = 0;
    trigty = 0.;
    good = 0;
    nstrip = 0.;
    qtot = 0.;
   ncore = 0.;
   qcore = 0.;
   impx = 0.;
   impy = 0.;
   tanx = 0.;
   tany = 0.;
   nint = 0.;
   ncyl = 0.;
   qcyl = 0.;
   qtrack = 0.;
   qmax = 0.;
   nx22 = 0.;
   qx22 = 0.;
   qtrackx = 0.;
   qtracky = 0.;
   dxtrack = 0.;
   dytrack = 0.;
   qlast = 0.;
   nlast = 0.;
   qpre = 0.;
   npre = 0.;
   qpresh = 0.;
   npresh = 0.;
   qlow = 0.;
   nlow = 0.;
   qtr = 0.;
   ntr = 0.;
   for (Int_t i=0; i<4;i++){
	qq[i] = 0.;
	swerr[i] = 0;
	perr[i] = 0;
	crc[i] = 0;
   };        
   for (Int_t i=0; i<2;i++){
       for (Int_t j=0; j<22;j++){
	   cibar[j][i] = 0;
	   cibar[j][i] = 0;
	   cbar[j][i] = 0.;
	   tbar[j][i] = 0.;
       };
   };
};

class CalorimeterADCRAW : public TObject {
 public:
    CalorimeterADCRAW();
    Int_t   evno;    
    Int_t   etime;
    Float_t estrip[2][22][96];
    Float_t diffbas[2][22][6];
};
CalorimeterADCRAW::CalorimeterADCRAW() {    
    for (Int_t i=0; i<2;i++){
	for (Int_t j=0; j<22;j++){
	    for (Int_t m=0; m<96;m++){
		if ( m < 6 ) diffbas[i][j][m] = 0.;
		estrip[i][j][m] = 0.;
	    };
	};	
    };        
};
